/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.block.effect;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.PotionBase;
import com.lycanitesmobs.client.AssetManager;
import com.lycanitesmobs.core.block.BlockFireBase;
import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.info.ElementManager;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockShadowfire
extends BlockFireBase {
    public boolean blindness;

    public BlockShadowfire() {
        super(Material.field_151581_o, LycanitesMobs.modInfo, "shadowfire");
        this.tickRate = 30;
        this.dieInRain = false;
        this.triggerTNT = false;
        this.agingRate = 3;
        this.spreadChance = 0.0f;
        this.removeOnTick = !ConfigBase.getConfig(this.group, "general").getBool("Features", "Enable Shadowfire", true);
        this.removeOnNoFireTick = ConfigBase.getConfig(this.group, "general").getBool("Features", "Remove Shadowfire on No Fire Tick", false);
        this.blindness = !ConfigBase.getConfig(this.group, "general").getBool("Features", "Shadowfire Blindness", true);
    }

    @Override
    protected boolean canNeighborCatchFire(World worldIn, BlockPos pos) {
        return false;
    }

    @Override
    protected int getNeighborEncouragement(World worldIn, BlockPos pos) {
        return 0;
    }

    @Override
    public boolean canCatchFire(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    @Override
    public boolean isBlockFireSource(Block block, World world, BlockPos pos, EnumFacing side) {
        return block == Blocks.field_150343_Z;
    }

    @Override
    protected boolean canDie(World world, BlockPos pos) {
        return false;
    }

    @Override
    public Item func_180660_a(IBlockState state, Random random, int zero) {
        return null;
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        super.func_180634_a(world, pos, state, entity);
        if (entity instanceof EntityItem) {
            return;
        }
        if (entity instanceof EntityLivingBase) {
            PotionEffect effectDecay;
            EntityLivingBase entityLiving = (EntityLivingBase)entity;
            PotionBase decay = ObjectManager.getEffect("decay");
            if (decay != null && entityLiving.func_70687_e(effectDecay = new PotionEffect((Potion)decay, 100, 0))) {
                entityLiving.func_70690_d(effectDecay);
            }
            PotionEffect effectBlindness = new PotionEffect(MobEffects.field_76440_q, 100, 0);
            if (this.blindness && entityLiving.func_70687_e(effectBlindness)) {
                entityLiving.func_70690_d(effectBlindness);
            }
        }
        if (entity instanceof BaseCreatureEntity && ((BaseCreatureEntity)entity).hasElement(ElementManager.getInstance().getElement("shadow"))) {
            return;
        }
        entity.func_70097_a(DamageSource.field_82727_n, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random random) {
        super.func_180655_c(state, world, pos, random);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (random.nextInt(24) == 0) {
            world.func_184134_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), AssetManager.getSound("shadowfire"), SoundCategory.BLOCKS, 0.5f + random.nextFloat(), random.nextFloat() * 0.7f + 0.3f, false);
        }
        for (int particleCount = 0; particleCount < 12; ++particleCount) {
            float particleX = (float)x + random.nextFloat();
            float particleY = (float)y + random.nextFloat() * 0.5f;
            float particleZ = (float)z + random.nextFloat();
            world.func_175688_a(EnumParticleTypes.SPELL_WITCH, (double)particleX, (double)particleY, (double)particleZ, 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

